##################################################################
# Description:   Logging activities on IRC                       #
# Author:        Norbert Kuemin <norbert.kuemin@gmx.net>         #
# Copyright:     Copyright 2000 by Norbert Kuemin                #
##################################################################
# Version   Date         Description                             #
#    1.00   26.07.2000   Initial coding                          #
##################################################################

package modules::remote;

use NoK::tools;

$VERSION = "1.00";
$NAME = "Remote";
$MODULE = "modules::remote";

sub new {
   my $proto = shift;

   my $conn = undef;
   if (scalar(@_) > 0) {
      $conn = shift;
   }

   my $config = undef;
   if (scalar(@_) > 0) {
      $config = shift;
   }

   my $eventhandler = undef;
   if (scalar(@_) > 0) {
      $eventhandler = shift;
   }

   my $modulehandler = undef;
   if (scalar(@_) > 0) {
      $modulehandler = shift;
   }

   my $self = {
         '_events'        => 'msg join part',
         '_config'        => $config,
         '_connection'    => $conn,
         '_eventhandler'  => $eventhandler,
         '_modulehandler' => $modulehandler,
         '_tools'         => new NoK::tools,
         '_forwardmsgto'  => '',
         '_channellist'   => {}
   };
   bless $self, $proto;

   return $self;
}

sub on_msg {
   $self = shift;
   my ($nick, $userhost, $text) = @_;
   $nick = $self->{'_tools'}->realnick($nick);
   # Security check (if possible)
   my @words = split(/ /,$text);
   my $cmd = uc(shift(@words));
   if ($cmd eq uc($self->{'_config'}->get('COMMANDPREFIX')."REMOTE")) {
      my $userhandler = $self->{'_modulehandler'}->get("modules::user");
      if (defined($userhandler)) {
         if ($userhandler->checkmode($nick,"m") == 0) {
            $userhandler->error($nick,"REMOTE","You cannot remote control this bot.");
            return;
         }
      }
      $cmd = uc(shift(@words));
      if ($cmd eq "MSG") {
         $target = shift(@words);
         $self->send_msg($target, join(" ",@words));
      }
      if ($cmd eq "ACTION") {
         $target = shift(@words);
         $self->send_action($target, join(" ",@words));
      }
      if ($cmd eq "KICK") {
         $channel = shift(@words);
         $nick = shift(@words);
         $self->{'_connection'}->kick($channel,$nick, join(" ",@words));
      }
      if ($cmd eq "TOPIC") {
         $target = shift(@words);
         $self->{'_connection'}->topic($target, join(" ",@words));
      }
      if ($cmd eq "NICK") {
         $self->{'_connection'}->nick(join(" ",@words));
      }
      if ($cmd eq "FORWARD") {
         $self->forward(join(" ",@words));
      }
      if ($cmd eq "NOFORWARD") {
         $self->noforward();
      }
      if ($cmd eq "AWAY") {
         my $text = join(" ",@words);
         $self->{'_connection'}->away($text);
         *DATA = $self->{'_channellist'};
         foreach $channel (keys %DATA) {
            if ($text eq "") {
               $self->send_action($channel, "is back");
            } else {
               $self->send_action($channel, "is away: ".$text);
            }
         }
         if ($text eq "") {
            $self->{'_eventhandler'}->action("away_off");
         } else {
            $self->{'_eventhandler'}->action("away_on");
         }
      }
   }
   if ($cmd eq uc($self->{'_config'}->get('COMMANDPREFIX')."HELP")) {
      my $userhandler = $self->{'_modulehandler'}->get("modules::user");
      if (defined($userhandler)) {
         if ($userhandler->checkmode($nick,"m") != 0) {
            $self->help($nick,@words);
         }
      } else {
         $self->help($nick,@words);
      }
   }
   if ($self->{'_forwardmsgto'} ne "") {
      $self->{'_connection'}->privmsg($self->{'_forwardmsgto'},"From $nick: $text");
   }
}

sub on_join {
   $self = shift;
   my ($channel, $nick, $userhost) = @_;
   if ($nick eq $self->{'_connection'}->nick()) {
      *DATA = $self->{'_channellist'};
      $DATA{$channel} = 1;
   }
}

sub on_part {
   $self = shift;
   my ($channel, $nick, $userhost) = @_;
   if ($nick eq $self->{'_connection'}->nick()) {
      *DATA = $self->{'_channellist'};
      delete($DATA{$channel});
   }
}

sub get_version {
   return $VERSION;
}

sub get_name {
   return $NAME;
}

sub get_module {
   return $MODULE;
}

sub get_events {
   $self = shift;
   return $self->{'_events'};
}

sub send_msg {
   $self = shift;
   my ($target,$text) = @_;
   $self->{'_connection'}->privmsg($target,$text);
}

sub send_action {
   $self = shift;  
   my ($target,$text) = @_;
   $self->{'_connection'}->me($target,$text);
}

sub forward {
   $self = shift;
   my ($nick) = @_;
   $self->{'_forwardmsgto'} = $nick;
}

sub noforward {
   $self = shift;
   $self->{'_forwardmsgto'} = "";
}

sub help {
   $self = shift;
   my $nick = shift;
   my $cmd1 = uc(shift);
   if (length($cmd1) == 0) {
      # print list
      $self->{'_connection'}->privmsg($nick,"remote          - Remote control the bot.");
   } else {
      if ($cmd1 eq "REMOTE") {
         # print sublist
         $self->{'_connection'}->privmsg($nick,"remote msg <channel> <msg>       - Send a message to a channel/nick.");
         $self->{'_connection'}->privmsg($nick,"remote action <channel> <action> - Send action to a channel/nick.");
      }
   }
}
