##################################################################
# Description:   Display answers from jargonfile                 #
# Author:        Norbert Kuemin <norbert.kuemin@gmx.net>         #
# Copyright:     Copyright 2003 by Norbert Kuemin                #
##################################################################
# Version   Date         Description                             #
#    1.00   08.06.2003   Initial coding                          #
##################################################################

package modules::jargon;

$VERSION = "1.00";
$NAME = "Jargon";
$MODULE = "modules::jargon";

sub new {
   my $proto = shift;

   my $conn = undef;
   if (scalar(@_) > 0) {
      $conn = shift;
   }

   my $config = undef;
   if (scalar(@_) > 0) {
      $config = shift;
   }

   my $eventhandler = undef;
   if (scalar(@_) > 0) {
      $eventhandler = shift;
   }

   my $modulehandler = undef;
   if (scalar(@_) > 0) {
      $modulehandler = shift;
   }

   my $self = {
         '_config'        => $config,
         '_connection'    => $conn,
         '_eventhandler'  => $eventhandler,
         '_modulehandler' => $modulehandler,
         '_events'        => 'msg'
   };
   bless $self, $proto;

   return $self;
}

sub on_public {
   $self = shift;
   my ($channel, $nick, $userhost, $text) = @_;
   $self->jargoncmd($channel, $text);
}

sub on_msg {
   $self = shift;
   my ($nick, $userhost, $text) = @_;
   $self->jargoncmd($nick, $text);
}

sub get_version {
   return $VERSION;
}

sub get_name {
   return $NAME;
}

sub get_module {
   return $MODULE;
}

sub get_events {
   $self = shift;
   return $self->{'_events'};
}

sub jargoncmd {
   $self = shift;
   my ($reply, $text) = @_;
   my @words = split(/ /,$text);
   my $cmd = uc(shift(@words));
   my $search = uc($self->{'_config'}->get('COMMANDPREFIX')."JARGON");
   if ($search eq $cmd) {
      my $out = $self->jargon_get($self->{'_config'}->get('JARGONFILE'),join(" ",@words));
      my @lines = split(/\n/,$out);
      foreach my $line (@lines) {
         $self->{'_connection'}->privmsg($reply,$line);
         sleep(2);
      }
   }
   $search = uc($self->{'_config'}->get('COMMANDPREFIX')."HELP");
   if ($search eq $cmd) {
      $self->help($reply);
   }
}

sub jargon_get {
   $self = shift;
   my ($filename, $key) = @_;
   my $retval = "";
   my $found = 0;
   if (open(FD, $filename) != 0) {
      while(<FD>) {
         if ($found == 0) {
            if (/:$key:/i) {
               $found = 1;
               $retval = $_;
            }
         } else {
            if (substr($_,0,1) eq ":") {
               $found = 0;
            } else {   
               $retval = $retval.$_;
            }
         }
      }
      close(FD);
   }
   return $retval;
}

sub help {
   $self = shift;
   my $nick = shift;
   $self->{'_connection'}->privmsg($nick,"jargon <text>   - Search for <text> in the jargon file.");
}
