##################################################################
# Description:   Logging activities on IRC                       #
# Author:        Norbert Kuemin <norbert.kuemin@gmx.net>         #
# Copyright:     Copyright 2000 by Norbert Kuemin                #
##################################################################
# Version   Date         Description                             #
#    1.00   26.07.2000   Initial coding                          #
##################################################################

package modules::admin;

use NoK::tools;

$VERSION = "1.00";
$NAME = "Admin";
$MODULE = "modules::admin";

sub new {
   my $proto = shift;

   my $conn = undef;
   if (scalar(@_) > 0) {
      $conn = shift;
   }

   my $config = undef;
   if (scalar(@_) > 0) {
      $config = shift;
   }

   my $eventhandler = undef;
   if (scalar(@_) > 0) {
      $eventhandler = shift;
   }

   my $modulehandler = undef;
   if (scalar(@_) > 0) {
      $modulehandler = shift;
   }

   my $self = {
         '_events'        => 'msg',
         '_config'        => $config,
         '_connection'    => $conn,
         '_eventhandler'  => $eventhandler,
         '_modulehandler' => $modulehandler,
         '_tools'         => new NoK::tools
   };
   bless $self, $proto;

   return $self;
}

sub on_msg {
   $self = shift;
   my ($nick, $userhost, $text) = @_;
   $nick = $self->{'_tools'}->realnick($nick);
   # Security check (if possible)
   my @words = split(/ /,$text);
   my $cmd = uc(shift(@words));
   if ($cmd eq uc($self->{'_config'}->get('COMMANDPREFIX')."ADMIN")) {
      my $userhandler = $self->{'_modulehandler'}->get("modules::user");
      if (defined($userhandler)) {
         if ($userhandler->checkmode($nick,"m") == 0) {
            $userhandler->error($nick,"ADMIN","You cannot admin this bot.");
            return;
         }
      }
      $cmd = uc(shift(@words));
      if ($cmd eq "MODULE") {
         $cmd = uc(shift(@words));
         if ($cmd eq "LIST") { $self->show_modules($nick); }
         if ($cmd eq "LOAD") { $self->load_modules($nick,@words); }
         if ($cmd eq "UNLOAD") { $self->unload_modules($nick,@words); }
         if ($cmd eq "RELOAD") { $self->reload_modules($nick,@words); }
      }
      if ($cmd eq "STOP") { $self->stop_bot($nick); }
      if ($cmd eq "CONFIG") {
         $cmd = uc(shift(@words));
         if ($cmd eq "LIST") { $self->show_config($nick); }
         if ($cmd eq "SET") { $self->set_config($nick,@words); }
#         if ($cmd eq "SAVE") { $self->save_config($nick); }
         if ($cmd eq "LOAD") { $self->load_config($nick); }
      }
      if ($cmd eq "IGNORE") { $self->ignore($nick,@words); }
      if ($cmd eq "UNIGNORE") { $self->unignore($nick,@words); }
   }
   if ($cmd eq uc($self->{'_config'}->get('COMMANDPREFIX')."HELP")) {
      my $userhandler = $self->{'_modulehandler'}->get("modules::user");
      if (defined($userhandler)) {
         if ($userhandler->checkmode($nick,"m") != 0) {
            $self->help($nick,@words);
         }
      } else {
         $self->help($nick,@words);
      }
   }
}

sub get_version {
   return $VERSION;
}

sub get_name {
   return $NAME;
}

sub get_module {
   return $MODULE;
}

sub get_events {
   $self = shift;
   return $self->{'_events'};
}

sub show_modules {
   $self = shift;
   my ($to) = @_;
   my @modulelist = $self->{'_modulehandler'}->list();
   foreach $module (@modulelist) {
      my $mod = $self->{'_modulehandler'}->get($module);
      $self->{'_connection'}->privmsg($to, $mod->get_module." (".$mod->get_name." ".$mod->get_version.")");
   }
}

sub load_modules {
   $self = shift;
   my ($nick, @modulelist) = @_;
   foreach my $module (@modulelist) {
      $ret = $self->{'_modulehandler'}->load($module);
      if ($ret) {
         $self->{'_connection'}->privmsg($nick,"Error: ".$ret);
      } else {
         $self->{'_connection'}->privmsg($nick,"Module $module loaded.");
      }
   }
}

sub unload_modules {
   $self = shift;
   my ($nick, @modulelist) = @_;
   foreach my $module (@modulelist) {
      $ret = $self->{'_modulehandler'}->unload($module);
      if ($ret) {
         $self->{'_connection'}->privmsg($nick,"Error: ".$ret);
      } else {
         $self->{'_connection'}->privmsg($nick,"Module $module unloaded.");
      }
   }
}

sub reload_modules {
   $self = shift;
   my ($nick, @modulelist) = @_;
   $self->unload_modules($nick, @modulelist);
   $self->load_modules($nick, @modulelist);   
}

sub stop_bot {
   $self = shift;
   $self->{'_connection'}->server("");
   $self->{'_connection'}->quit();
}

sub show_config {
   $self = shift;
   my ($to) = @_;
   my @list = $self->{'_config'}->list();
   foreach $cfg (@list) {
      my $val = $self->{'_config'}->get($cfg);
      $self->{'_connection'}->privmsg($to, $cfg."=".$val);
   }
}

sub set_config {
   $self = shift;
   my $nick = shift;
   my $text = join(" ",@_);
   my ($var, $val) = split(/=/,$text,2);
   $self->{'_config'}->set($var,$val);
   $self->{'_connection'}->privmsg($nick, "Setting $var to '$val'.");
}


sub load_config {
   $self = shift;
   my ($nick) = @_;
   $self->{'_config'}->load();
   $self->{'_connection'}->privmsg($nick, "Configuration loaded.");
}

sub ignore {
   $self = shift;
   my $nick = shift;
   my $user = shift;
   $ignore_list = $self->{'_config'}->get("IGNORE");
   if (index(";".$ignore_list.";",";".$user.";") == -1) {
      if ($ignore_list ne "") { $ignore_list = $ignore_list.";"; }
      $ignore_list = $ignore_list.$user;
      $self->{'_config'}->set("IGNORE",$ignore_list);
      $self->{'_eventhandler'}->action("ignore",$user);
   }
}

sub unignore { 
   $self = shift;
   my $nick = shift;
   my $user = shift;
   $ignore_list = $self->{'_config'}->get("IGNORE");
   if (index(";".$ignore_list.";",";".$user.";") > -1) {
      $ignore_list = ";".$ignore_list.";";
      my $search = ";".$user.";";
      $ignore_list =~ s/$search/;/g;
      if (length($ignore_list) > 2) {
         $ignore_list = substr($ignore_list,1,length($ignore_list)-2);
      } else {
         $ignore_list = "";
      }
      $self->{'_config'}->set("IGNORE",$ignore_list);
      $self->{'_eventhandler'}->action("unignore",$user);
   }
}

sub help {
   $self = shift;
   my $nick = shift;
   my $cmd1 = uc(shift);
   if (length($cmd1) == 0) {
      # print list
      $self->{'_connection'}->privmsg($nick,"admin           - Admin the bot(help admin).");
   } else {
      if ($cmd1 eq "ADMIN") {
         my $cmd2 = uc(shift);
         if (length($cmd2) == 0) {
            # print sublist
            $self->{'_connection'}->privmsg($nick,"admin config list   - List all config parameters and values.");
            $self->{'_connection'}->privmsg($nick,"admin config set    - Set a config parameter to a new value.");
            $self->{'_connection'}->privmsg($nick,"admin config save   - Save the current config to the config file.");
            $self->{'_connection'}->privmsg($nick,"admin config load   - ");
            $self->{'_connection'}->privmsg($nick,"admin module list   - ");
            $self->{'_connection'}->privmsg($nick,"admin module load   - ");
            $self->{'_connection'}->privmsg($nick,"admin module unload - ");
            $self->{'_connection'}->privmsg($nick,"admin module reload - ");
            $self->{'_connection'}->privmsg($nick,"admin stop          - ");
         } else {
            my $cmd3 = uc(shift);
         }
      }
   }
}
