##################################################################
# Description:   Handling the dynamic modules for yabba          #
# Author:        Norbert Kuemin <norbert.kuemin@gmx.net>         #
# Copyright:     Copyright 2000 by Norbert Kuemin                #
##################################################################
# Version   Date         Description                             #
#     1.0   26.07.2000   Initial coding                          #
##################################################################

package NoK::modules;

$VERSION = "1.00";

sub new {
   my $proto = shift;

   my $conn = undef;
   if (scalar(@_) > 0) {
      $conn = shift;
   }

   my $config = undef;
   if (scalar(@_) > 0) {
      $config = shift;
   }

   my $eventhandler = undef;
   if (scalar(@_) > 0) {
      $eventhandler = shift;
   }

   my $self = {
         '_config'       => $config,
         '_connection'   => $conn,
         '_eventhandler' => $eventhandler,
         '_modules'      => {}
      };

   bless $self, $proto;

   print "Loading modules:\n";
   foreach my $module (split(/;/,$self->{'_config'}->get('MODULES'))) {
      print "-> $module";
      $ret = $self->load($module);
      if ($ret) {
         print "\n".$ret;
      } else {
         print " (".$self->{'_modules'}->{$module}->get_name()." ".$self->{'_modules'}->{$module}->get_version().")\n";
      }
   }
   return $self;
}

sub load {
   $self = shift;
   foreach my $module (@_) {
      eval "use $module";
      if ($@) {
         return $@;
      } else {
         eval "\$self->{'_modules'}->{$module} = new $module (\$self->{'_connection'}, \$self->{'_config'}, \$self->{'_eventhandler'}, \$self)";
         if ($@) {
            return $@;
         } else {
            my $modevents = ($self->{'_modules'}->{$module}->get_events());
            foreach my $event (split(" ",$modevents)) {
               $self->{'_eventhandler'}->add($event, $self->{'_modules'}->{$module});
            }
            $self->{'_eventhandler'}->action("modload",$module,$self->{'_modules'}->{$module});
         }
      }
   }
}

sub unload {
   $self = shift;
   foreach my $module (@_) {
      if (defined($self->{'_modules'}->{$module})) {
         $self->{'_eventhandler'}->remove_module($self->{'_modules'}->{$module});
         $self->{'_eventhandler'}->action("modunload",$module);
         $self->{'_modules'}->{$module}->DESTROY();
         delete $self->{'_modules'}->{$module};
      } else {
         return "$module not found."
      }
   }
}

sub reload_modules {
   $self = shift;
   $ret = $self->unload_modules(@_);
   if ($ret) { return $ret; }
   $ret =$self->load_modules(@_);
   if ($ret) { return $ret; }
}

sub get {
   $self = shift;
   $module = shift;
   if (defined($self->{'_modules'}->{$module})) {
      return $self->{'_modules'}->{$module};
   } else {
      return;
   }
}

sub list {
   $self = shift;
   *MOD = $self->{'_modules'};
   return keys %MOD;
}