##################################################################
# Description:   Handling the configuration for yabba            #
# Author:        Norbert Kuemin <norbert.kuemin@gmx.net>         #
# Copyright:     Copyright 2000 by Norbert Kuemin                #
##################################################################
# Version   Date         Description                             #
#     1.0   15.07.2000   Initial coding                          #
##################################################################

package NoK::config;

$VERSION = "1.00";

sub new {
   my $proto = shift;
   my $file = shift;

   my $self = {
         '_file' => ($file  ||  'jabba.config'),
         '_config' => {}
      };

   bless $self, $proto;

   print "Loading configuration...";
   $self->load();
   print " done.\n";

   return $self;
}

sub get {
   $self = shift;
   my $var = shift;
   if (defined($self->{'_config'}{$var})) {
      return $self->{'_config'}{$var};
   } else {
      return;
   }
}

sub set {
   $self = shift;
   my ($var, $val) = @_;
   $var = uc($var);
   $self->{'_config'}{$var} = $val;
}

sub load {
   $self = shift;
   
   open FD, $self->{'_file'}
      or die "perlbot: Can't read config file '".$self->{'_file'}."'.\n";
   $self->{'_config'} => {};
   while (<FD>) {
      chomp;
      if (substr($_,0,1) ne "#") {
         my ($var, $val) = split(/=/,$_,2);
         $var = uc($var);
         $self->{'_config'}{$var} = $val;
      }
   }
   close FD;
}

sub list {
   $self = shift;
   *CFG = $self->{'_config'};
   return keys %CFG;
}
